﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private Const BEAMCOUNT As Integer = 24
    Private Const INCREMENT As Double = Math.PI / BEAMCOUNT


    Public Sub New()
        InitializeComponent()
    End Sub


    Private Sub OnLoaded(ByVal sender As Object, ByVal args As RoutedEventArgs) Handles Me.Loaded
        Dim center As New Point(ContentPanel.ActualWidth / 2,
                                ContentPanel.ActualHeight / 2)

        Dim radius = 0.45 * Math.Min(ContentPanel.ActualWidth,
                                               ContentPanel.ActualHeight)
        Dim innerRadius = 0.8 * radius

        For i = 0 To BEAMCOUNT - 1
            Dim radians = 2 * Math.PI * i / BEAMCOUNT

            If i = 0 Then
                pathFigure.StartPoint = New Point(center.X, center.Y - radius)
            End If

            Dim lineSeg As New LineSegment()
            lineSeg.Point = New Point(
                center.X + innerRadius * Math.Sin(radians + INCREMENT / 2),
                center.Y - innerRadius * Math.Cos(radians + INCREMENT / 2))
            pathFigure.Segments.Add(lineSeg)

            Dim arcSeg As New ArcSegment()
            arcSeg.Point = New Point(
                center.X + innerRadius * Math.Sin(radians + 3 * INCREMENT / 2),
                center.Y - innerRadius * Math.Cos(radians + 3 * INCREMENT / 2))
            pathFigure.Segments.Add(arcSeg)

            lineSeg = New LineSegment()
            lineSeg.Point = New Point(
                center.X + radius * Math.Sin(radians + 2 * INCREMENT),
                center.Y - radius * Math.Cos(radians + 2 * INCREMENT))
            pathFigure.Segments.Add(lineSeg)
        Next i
    End Sub
End Class
